use "/Users/natashasarin/Desktop/Desktop_20151003/Bank/Data/MostRecentDataUsed/Options/StockOptionPrice_20150812.dta", clear 

drop if missing(delta)
drop if optionid == . 
drop if cp_flag == "C"
drop if monthstoexpiration <= 2 
by issuer date, sort: gen moneyratio2 = 1-((strike_price/1000)/close)
by issuer date, sort: gen moneyratio = close/(strike_price/1000)-1
keep if moneyratio2 >= 0 
gen year = year(date) 
drop if year < 2002 
gen diff = -moneyratio2
by issuer date (diff), sort: gen rank = _n 
drop if rank >= 2 

****here is where we control the kind of options that we get 
gen strike_priceb = close*.25

*Now we need to get d1 to calculate what the put delta is on new options 
gen price_ratio = close/strike_priceb
gen logprice_ratio = log(price_ratio)


merge 1:1 issuer date using "/Users/natashasarin/Desktop/Desktop_20151003/Bank/Data/MostRecentDataUsed/Options/divyield.dta"
drop _merge

merge m:1 date year using "/Users/natashasarin/Desktop/Desktop_20151003/Bank/Data/MostRecentDataUsed/Options/dailyrates.dta"
gen rfrate_n = real(rfrate)
gen volsq = impl_volatility^2
gen rfrate_n100 = rfrate_n/100
gen d1 = (logprice_ratio + (rfrate_n100 - DividendYield+ volsq/2))/impl_volatility 
gen d1b = (logprice_ratio + 4*(rfrate_n100 - DividendYield+ volsq/2))/(2*impl_volatility) 

br issuer year impl_volatility rfrate_n100 d1 d1b 

drop if impl_volatility == . 
drop if issuer == " " 

by issuer date, sort: gen test = . 

keep issuer date stock_ticker strike_pricea close impl_volatility moneyness 

gen imp_vol_options = impl_volatility*100 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/option_vol_comparison.dta", replace

use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/option_vol_comparison.dta", clear 
*** need to add in permnos here 

gen permno = . 
replace permno = 38703 if stock_ticker == "WFC"
replace permno = 86868 if stock_ticker == "GS"
replace permno  = 70519 if stock_ticker == "C"
replace permno = 59408 if stock_ticker == "BAC"
replace permno = 47896 if stock_ticker == "JPM"
replace permno = 69032 if stock_ticker == "MS"

br if permno == . 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/option_vol_comparison.dta", replace


use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt_v2.dta", clear 
capture drop _merge 
*** match on permno, date
merge m:m permno date using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/option_vol_comparison.dta"
drop if year < 2002 
drop if year > 2014 
br if _merge != 3 
drop if _merge != 3 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/option_vol_comparison_v2.dta", replace

*** plot option vol against regular vol, also as three month moving avg. 
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/option_vol_comparison_v2.dta", clear


egen id = group(name)
tsset id date 
tssmooth ma vol_ma = vol, window(90)
tssmooth ma imp_vol_options_ma = imp_vol_options, window(90)
gen neg_vol_ma = -vol 

label var vol_ma "Volatility"
label var imp_vol_options_ma "Implied Volatility, 50% OTM Put"
label var neg_vol_ma "Volatility (Negative)" 

cd "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/Tables"

graph twoway (line neg_vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line imp_vol_options_ma date, yaxis(2) cmissing(no) ytitle("Option Volatility", axis(2))) if (name == "baml"), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_optionvol.png, replace 

graph twoway (line neg_vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line imp_vol_options_ma date, yaxis(2) cmissing(no) ytitle("Option Volatility", axis(2))) if (name == "citi"), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_optionvol.png, replace 


graph twoway (line neg_vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line imp_vol_options_ma date, yaxis(2) cmissing(no) ytitle("Option Volatility", axis(2))) if (name == "ms"), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_optionvol.png, replace 

graph twoway (line neg_vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line imp_vol_options_ma date, yaxis(2) cmissing(no) ytitle("Option Volatility", axis(2))) if (name == "gs"), xtitle("") title("Goldman Sachs") xlabel(,labsize(small)) 

graph export gs_optionvol.png, replace 

graph twoway (line neg_vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line imp_vol_options_ma date, yaxis(2) cmissing(no) ytitle("Option Volatility", axis(2))) if (name == "wf"), xtitle("") title("Wells Fargo") xlabel(,labsize(small)) 

graph export wf_optionvol.png, replace 

graph twoway (line neg_vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line imp_vol_options_ma date, yaxis(2) cmissing(no) ytitle("Option Volatility", axis(2))) if (name == "jpm"), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_optionvol.png, replace 
*** now we have daily options implied vol data 

*** want to add in our daily vol, imp vol LT data and drop when there is no match 

/*

**** then we export to excel to clc N(d1) 

import excel "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/options_data_d1_09072016.xlsx", sheet("Sheet1") firstrow clear

rename CH Nd2
gen Nd1_2 = Nd1 - 1
gen Nd2_2 = Nd2 - 1
gen qt_1 = DividendYield*(-1)
gen qt_2 = DividendYield*(-4)

gen delta_1 = exp(qt_1)*Nd1_2
gen delta_2 = exp(qt_2)*Nd2_2

gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 

by crisis issuer, sort: egen mean_delta_1 = mean(delta_1)
by crisis issuer, sort: egen mean_delta_2 = mean(delta_2) 

capture drop output_indicator 
by crisis issuer, sort: gen output_indicator = _n 

br crisis issuer mean_delta_1 if (output_indicator == 1 & crisis != .)

by year issuer, sort: egen mean_delta_1_y = mean(delta_1)
by year issuer, sort: egen mean_delta_2_y = mean(delta_2) 
capture drop output_indicator 

by issuer year, sort: gen output_indicator = _n 
br if (year == 2015 | year == 2014) & output_indicator == 1

***** then we want to do the same thing for our new 75 percent options 

import excel "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/options_data_d1_09072016.xlsx", sheet("Sheet2") firstrow clear
rename CH Nd2 
gen Nd1_2 = Nd1 - 1
gen Nd2_2 = Nd2 - 1
gen qt_1 = DividendYield*(-1)
gen qt_2 = DividendYield*(-4)

gen delta_1 = exp(qt_1)*Nd1_2
gen delta_2 = exp(qt_2)*Nd2_2

gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 

by crisis issuer, sort: egen mean_delta_1 = mean(delta_1)
by crisis issuer, sort: egen mean_delta_2 = mean(delta_2) 

capture drop output_indicator 
by issuer crisis, sort: gen output_indicator = _n 

br if (output_indicator == 1 & crisis != .)

by year issuer, sort: egen mean_delta_1_y = mean(delta_1)
by year issuer, sort: egen mean_delta_2_y = mean(delta_2) 
capture drop output_indicator 

by issuer year, sort: gen output_indicator = _n 
br if (year == 2015 | year == 2014) & output_indicator == 1
